<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

define("_MENU_POS_LEFT" , 1);
define("_MENU_POS_RIGHT" , 0);

/**
* description
*
* @library	
* @author	
* @since	
*/
class CMenus extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "menus";
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"		=> "main.htm",
			"links"		=> "links.htm",
			"dropdown"	=> "dropdown.htm",
			"mega"		=> "mega.htm",
			"common"	=> "common.htm",
		);

		if (count($templates)) {
			foreach ($templates as $key => $val) {
				$this->private->templates[$key] = new CTemplateDynamic(
					$path . $val 
				);
			}
		}

		$this->__CacheMenus();

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __CacheMenus() {

		global $base;


		$start = microtime(true);


		$cond = array();

		//add condition to enable / disable for certain modules
		if (is_array($module = $this->plugins["globalhooks"]->module_data)) {
			if ($module["mod_id"]) {
				$cond[] = "				
					( 
						(menu_status = 1) OR 
						((menu_status = 2) AND find_in_set({$module['mod_id']} , menu_modules)) OR 
						((menu_status = 3) AND NOT find_in_set({$module['mod_id']} , menu_modules))
					)
				";
			} else {
				$cond[] = "
				
					( 
						(menu_status = 1) OR 
						((menu_status = 2) AND find_in_set({$module['module_id']} , menu_modules_global)) OR 
						((menu_status = 3) AND NOT find_in_set({$module['module_id']} , menu_modules_global))
					)
				";
			}			
		} else {
			$cond[] = "menu_status > 0 ";
		}

		//check to be on the right device
		if ($base->isTablet) {
				$cond[]= " find_in_set(2,menu_device) ";
		} elseif ($base->isMobile) {
				//phone
				$cond[] = "find_in_set(3,menu_device) ";
			} else {
				//desktop
				$cond[] = "find_in_set(1,menu_device) ";
			}


		$menus = $this->db->QFetchRowArray("
			SELECT * FROM 
				{$this->tables['core:menu_zones']} " . ( count($cond) ? "WHERE " . implode(" AND " , $cond) : "" )
		);

		$this->menus = $menus;
		$this->cacheMenus($menus);

	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Menus() {
		global $base;

		$this->__init();


		$menus = $this->menus;


		if (is_array($menus)) {

			foreach ($menus as $key => $val) {

				if ($val["menu_file"]) {
					$this->private->templates[$val["menu_file"]] = new CTemplateDynamic($this->tpl_path . $val["menu_file"]);
				}
				

				$_menu[$val["menu_id"]] = array(
					"content"	=> $content = $this->GenerateMenu($val , ($this->vars->data["set_menu_collapse_logo"] == $val["menu_id"]) || ($this->vars->data["set_menu_side_logo"] == $val["menu_id"])),
					"trigger"	=> $content ? $this->GenerateMenuTrigger($val) : "",
				);
			}			
		}

//		$time = microtime(true) - $start;
//		debug("<span style='color: red'>Menus:" . $time ."ms</span>");

		return $_menu;		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GenerateMenu($menu , $showlogo) {
		global $base , $_LANG_ID , $_SESS;

		//get the invoices
		$items = $this->cache[$menu["menu_id"]];
		$this->validateItems($items);


		if (!(is_array($items) || $menu["menu_extra"])) {
			return "";
		}

		if (is_Array($items)) {	
			foreach ($items as $key => $val) {

				$item = array();

				switch ($val["item_type"]) {

					//link to instance module
					case "1":
						$item["content"] = $this->itemLinkToInstanceModule($val);
					break;

					//link to global module
					case "2":
						$item["content"] = $this->itemLinkToGlobalModule($val);
					break;

					//link to page
					case "3":
						$item["content"] = $this->itemLinkToPage($val);
					break;

					//drop menu
					case "4":
						$item["content"] = $this->itemDropDownMenu($val);
					break;
					
					//drop-down mega menu
					case "5":
						$item["content"] = $this->itemDropDownMegaMenu($val);
					break;

					//drop-down menu
					case "6":
						$item["content"] = $this->itemText($val);
					break;
				}					

				if ($item["content"]) {
					switch ($menu["menu_id"]) {
						//main navigation
						case "1":
							switch ($this->vars->data["set_menu_style"]) {
								case "lr":
								case "lc":
									$_menu[$val["item_pos"]][] = $item;			
								break;

								case "r":
									$_menu[_MENU_POS_RIGHT][] = $item;			
								break;

								case "c":
								case "l":
									$_menu[_MENU_POS_LEFT][] = $item;			
								break;
							}
							
						break;

						//all other menus
						default:
							$_menu[$val["item_pos"]][] = $item;			
						break;
					}
				}										
			}
		}

		$tpl = $this->_t($menu["menu_file"]) ? $this->_t($menu["menu_file"])  : $this->_t("generic");

		return $tpl->blockReplace(
			"Menu",
			array(
				"_left"		=> is_array($_menu[_MENU_POS_LEFT]) ? $tpl->blockReplace(
					"Left" , 
					array(
						"menu" => $base->html->table(
							$tpl, 
							"",
							$_menu[_MENU_POS_LEFT]
						)
					)
				) : "",

				"_right"	=> is_array($_menu[_MENU_POS_RIGHT]) ? $tpl->blockReplace(
					"Right",
					array(
						"menu"	=> $base->html->table(
							$tpl , 
							"" , 
							$_menu[_MENU_POS_RIGHT]
						)
					)
				) : "",

				"_extra"	=> $menu["menu_extra"] ? $tpl->blockReplace("Extra" , $menu) : "",


				"_logo"		=> $showlogo ? $tpl->blockReplace("Logo") : "",
			)
		);

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemLinkToPage($item) {
		
		return $this->_t("links")->blockReplace(
			"Link" ,
			array(	
				"id"		=> $item["item_id"],
				"title"		=> $item["item_name"],
				"link"		=> $item["item_link"],

				"target"	=> $item["item_link_target"] ? $this->_t("common")->blockReplace("Target") : "",
				"rel"		=> $item["item_link_rel"],
				"selected"	=> "",

				"icon"		=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $item) : "",
				"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $item["item_name"])) : "",
			),
			$item
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemLinkToInstanceModule($item, $html = true) {

		$mod = $this->plugins["modules"]->modules[$item["item_module"]];

		if (!is_array($mod)) {
			return "";
		}		

		if (!is_object($this->plugins[$mod["mod_module_code"]])) {
			return "";
		}		

		$data = $this->plugins[$mod["mod_module_code"]]->GetMenuButton($mod);

		if ($data["html"] && $html) {
			return $data["html"];
		}
						
		return $this->_t("links")->blockReplace(
			"Link" ,
			array(	
				"id"		=> $mod["mod_id"],
				"title"		=> $item["item_name"] ? $item["item_name"] : $mod["mod_name"],
				"link"		=> $mod["link"],

				"target"	=> "",
				"rel"		=> "",
				"selected"	=> $data["selected"] ? $this->_t("common")->blockReplace("Selected") : "",

				"icon"		=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $item) : "",
				"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $item["item_name"] ? $item["item_name"] : $mod["mod_name"])) : "",

			),
			$item
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemLinkToGlobalModule($item , $html = true) {

		//read the module
		$mod = $this->plugins["modules"]->LoadDefaultModule($item["item_module_global"] , false , "id");

		//if doesnt exists return nothing
		if (!is_array($mod)) {
			return "";
		}

		$data = $this->plugins[$mod["module_code"]]->GetMenuButton($mod);

		if (!is_array($data)) {
			return "";
		}

		//if was already computed return the html
		if ($data["html"]) {

			if ($html) {
				return $data["html"];
			} else {
				return $this->_t("links")->blockReplace(
					"Link" ,
					array(	
						"id"		=> $mod["module_id"] . "-" . (++$cnt),
						"title"		=> $mod["module_name"],
						"link"		=> $mod["link"],

						"target"	=> "",
						"rel"		=> "",
						"selected"	=> $_GET["mod"] == $mod["module_code"] ? $this->_t("common")->blockReplace("Selected") : "",

						"icon"		=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $item) : "",

						"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $mod["module_name"])) : "",
					),
					$item
				);
			}
			
		}

		if (is_Array($data)) {

			return $this->_t("links")->blockReplace(
				"Link" ,
				array(	
					"id"		=> $mod["module_id"] . "-" . (++$cnt),
					"title"		=> $data["title"],
					"link"		=> $data["link"],

					"target"	=> "",
					"rel"		=> "",
					"selected"	=> $data["selected"] ? $this->_t("common")->blockReplace("Selected") : "",

					"icon"		=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $item) : "",
					"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $data["title"])) : "",

				),
				$item
			);

		}
				
		//else i need bo build the html		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemText($item) {
		return $this->_t("links")->blockReplace(
			"Text",
			array(
				"title"			=> $item["item_name"],
				"icon"			=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $val) : "",
				"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $item["item_name"])) : "",
				"id"			=> $item["item_id"],
			),
			$item
		);
	}
	
		

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemDropDownMenu($item) {
		global $base;

		//read the links based on category type
		switch ($item["item_cat_type"]) {
			case "0":
				$links = $this->getDropDownManualLinks($item);
			break;

			case "1":
				$links = $this->getDropDownCatLinks($item["item_cat_categories"]);
			break;
		}


		//if no links return empty
		if (!is_array($links)) {
			return "";
		}

		//split the items in multiple columns
		if ($item["item_cat_size"] > 1) {
			$cnt = ceil(count($links) / $item["item_cat_size"] );			
			$submenu = array_chunk($links, $cnt);		
		} else {
			$submenu = array(
				$links
			);
		}

		foreach ($submenu as $key => $val) {
			$submenu[$key] = array(
				"col" => $base->html->Table(
					$this->_t("dropdown"),
					"Menu",
					$val
				)
			);
		}

		$content = $this->_t("dropdown")->blockReplace(
			"MenuContent",
			array(
				"cols"	=> $base->html->Table(
					$this->_t("dropdown"),
					"Cols",
					$submenu,
					array(
						"item_css_class"	=> "",
						"size"			=> $item["item_cat_size"],
						"item_cat_size"	=> $item["item_cat_size"]
					)
				),
			),
			$this->itemDropDownMenuRes($item),
			$this->plugins["backgrounds"]->GetBg($item["item_cat_background"])
		);

		//look up in items for a "selected" one
		$selected = strpos($content , "active") !== false ? true : false;

		return $this->_t("dropdown")->blockReplace(
			"Menu" , 
			array(

				"_content"	=> $content,

				"id"		=> $item["item_id"],
				"title"		=> $item["item_name"],

				"selected"	=> $selected ? $this->_t("common")->blockReplace("Selected") : "",

				"icon"		=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $item) : "",
				"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $item["item_name"])) : "",

			),
			$item
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function itemDropDownMenuRes($item) {


		switch ($item["item_cat_res_type"]) {
			default:
				return array(
					"res"		=> "",
					"res_class"	=> "",
					"res_pos"	=> "",
				);
			break;

			//image
			case "1":
				return array(
					"res"		=> $this->_t("dropdown")->blockReplace(
						"ResImage",
						array(
							"item_id"		=> $item["item_id"],
							"res_align"		=> $item["item_cat_res_align"] ,
							"res_valign"	=> in_array($item["item_cat_res_pos"] , array("dropdown-menu-res-top" , "dropdown-menu-res-bottom"))  ? "" : $item["item_cat_res_valign"],
						)
					),
					"res_class"	=> "dropdown-with-res",
					"res_pos"	=> $item["item_cat_res_pos"],
				);
			break;

			//html
			case "1":
				return array(
					"res"		=> $this->_t("dropdown")->blockReplace(
						"ResHTML",
						array(
							"html"			=> $item["item_cat_res_html"],
							"res_align"		=> $item["item_cat_res_align"],
							"res_valign"	=> in_array($item["item_cat_res_pos"] , array("dropdown-menu-res-top" , "dropdown-menu-res-bottom"))  ? "" : $item["item_cat_res_valign"],
						)
					),
					"res_class"	=> "dropdown-with-res",
					"res_pos"	=> $item["item_cat_res_pos"],
				);
			break;

		}		

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemDropDownMegaMenu($item) {

		switch ($item["item_mega_type"]) {

			case "0":
				return $this->itemDropDownMegaMenuCategories($item);
			break;

			case "1":
				return $this->itemDropDownMegaMenuLayout($item);
			break;
		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemDropDownMegaMenuLayout($item) {

		return $this->_t("mega")->BlockReplace(
			"Menu" , 
			array(
				"title"			=> $item["item_name"],
				"id"			=> $item["item_id"],
				"content"		=> $this->_t("mega")->blockReplace(
					"Layout",
					array(
						"content"	=> $content = $this->plugins["layouts"]->Render($item["item_mega_layout"] , "")
					)
				),
				"mega_style"	=> $item["item_mega_style"] ? "with-megadrop-boxed" : "with-megadrop-full",
				"selected"		=> (strpos($content , "active") !== false)   ? $this->_t("common")->blockReplace("Selected") : "",

				"icon"			=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $item) : "",
				"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $item["item_name"])) : "",
			),
			$item
		);
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function itemDropDownMegaMenuCategories($item) {
		global $base;

		if (!trim($item["item_mega_categories"])) {
			return "";
		}
		
		$cats = explode("," , $item["item_mega_categories"]);

		if (!count($cats)) {
			return "";
		}

		//sort the cats base 
		foreach ($cats as $key => $val) {
			$cats[$key] = array("id" => trim($val));
		}

		$cats = SortByKeys($cats , "id" , $item["item_mega_categories"]);

		//read the menu itesms
		foreach ($cats as $key => $val) {
			$links = $this->getDropDownCatLinks($val["id"] , true);

			$cats[$key]["links"] = is_array($links) ? $base->html->Table(
				$this->_t("mega"),
				"Links",
				$links,
				$val				
			) : "";

			$cats[$key]["_title"] = $item["item_mega_elements"] ? $this->_t("mega")->blockReplace("CategoryTitle" , $this->plugins["modules"]->modules[$val["id"]]) : "";
		}


		return $this->_t("mega")->BlockReplace(
			"Menu" , 
			array(
				"title"			=> $item["item_name"],
				"id"			=> $item["item_id"],
				"content"		=> $content = $this->_t("mega")->blockReplace(
					"Categories",
					array(
						"content"	=> $base->html->table(
							$this->_t("mega"),
							"Categories",
							$cats							
						)
					),
					$item,
					$this->plugins["backgrounds"]->GetBg($item["item_mega_background"])
				),

				"mega_style"	=> $item["item_mega_style"] ? "with-megadrop-boxed" : "with-megadrop-full",

				//try to detect if there is any active item inside
				"selected"		=> strpos($content , "active") !== false ? $this->_t("common")->blockReplace("Selected") : "",
				"icon"			=> $item["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $item) : "",
				"_item_title"	=> $item["item_elements"] == "name" ? $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $item["item_name"])) : "",
			),
			array(
				"id"			=> $item["item_id"],
			),
			
			$item
		);

	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getDropDownManualLinks($cat, $nohtml = false) {
		global $_LANG_ID;
		
		//get the invoices
		$items = $this->cache[$cat["menu_id"]][$cat["item_id"]]["sub"];
		$this->validateItems($items);

		if (!is_array($items)) {
			return "";
		}


		foreach ($items  as $key => $val) {

			$item = array();

			switch ($val["item_type"]) {

				//link to page
				case "1":
					$item["content"] = $this->itemLinkToInstanceModule($val);
				break;

				//link to global module
				case "2":
					$item["content"] = $this->itemLinkToGlobalModule($val , false);
				break;

				//manual link
				case "3":
					$item["content"] = $this->itemLinkToPage($val);
				break;
			}

			
			if (count($item)) {
				$_items[] = $item;
			}			
		}

		return $_items;

	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getDropDownCatLinks($cat_id , $nohtml = false) {

		$items = $this->plugins["modules"]->GetModulesByParent($cat_id);

		if (!is_array($items)) {
			return "";
		}


		foreach ($items as $key => $val) {

			$data = $this->plugins[$val["mod_module_code"]]->GetMenuButton($val);

			if ($data["html"] && !$nohtml) {
				$items[$key]["content"] = $data["html"]; 
			} else {
				$items[$key]["content"] = $this->_t("links")->blockReplace(
					"Link",
					array(
						"id"		=> $val["id"],
						"title"		=> $data["title"],
						"link"		=> $data["link"],

						"target"	=> "",
						"rel"		=> "",

						"selected"	=> $data["selected"] ? $this->_t("common")->blockReplace("Selected") : "",

						"icon"		=> "",
						"_item_title"	=> $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $data["title"])) ,
					)
				);
			}
			
		}
		
		return $items;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GenerateMenuTrigger($menu) {
		if ($menu["menu_file"] && is_array($this->cache[$menu["menu_id"]])) {
			return $this->_t($menu["menu_file"])->blockReplace(
				"Button",
				array(
					"button"	 => ($menu["menu_btn_type"] == "2") && ($menu["menu_btn_icon"]) ? $this->_t("common")->blockReplace("Icon" , $menu) : $this->_t("common")->blockReplace("Hamburger"),
				)
			);
		} else {
			return "";
		}
		
	}
	
	
	
	
	/**
	* description

$item = array(
	size	=> "1",
	title	=> "title",
	bg		=> "id"
);
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function dropdownHtml($item , $links) {
		global $base;

		if (!is_array($links)) {
			return "";
		}
		//look up in items for a "selected" one
		$selected = false;
		foreach ($links as $key => $val) {
			if ($val["selected"]) {
				$selected = true;
			}		
			
			$links[$key]["content"] = $this->_t("links")->blockReplace(
				"Link" ,
				array(	
					"id"		=> $val["item_id"],
					"title"		=> $val["title"],
					"link"		=> $val["link"],

					"target"	=> "",
					"rel"		=> "",
					"selected"	=> $val["selected"] ? $this->_t("common")->blockReplace("Selected") : "",

					"icon"		=> $item["icon"] ? $this->_t("common")->blockReplace("ItemIcon", array("item_icon" => $val["icon"])) : "",
					"_item_title"	=> $this->_t("common")->blockReplace("ItemTitle", $val),
				)
			);
		}		


		//split the items in multiple columns
		if ($item["size"] > 1) {
			$cnt = ceil(count($links) / $item["size"] );
			$submenu = array_chunk($links, $cnt);		
		} else {
			$submenu = array(
				$links
			);
		}


		foreach ($submenu as $key => $val) {
			$submenu[$key] = array(
				"col" => $base->html->Table(
					$this->_t("dropdown"),
					"Menu",
					$val
				)
			);
		}

		//get the background

		return $this->_t("dropdown")->blockReplace(
			"Menu" , 
			array(

				"_content"	=> $this->_t("dropdown")->blockReplace(
					"MenuContent",
					array(
						"cols"	=> $base->html->Table(
							$this->_t("dropdown"),
							"Cols",
							$submenu
						),

						"res"		=> "",
						"res_class"	=> "",
						"pos_class"	=> "",
					),
					$bg = $this->plugins["backgrounds"]->GetBg($item["bg"])
				),

				"id"		=> $item["id"],
				"title"		=> $item["title"],

				"selected"	=> $selected ? $this->_t("common")->blockReplace("Selected") : "",

				"icon"			=> $item["icon"] ? $this->_t("common")->blockReplace("ItemIcon", array("item_icon" => $item["icon"])) : "",
				"_item_title"	=> $this->_t("common")->blockReplace("ItemTitle", $item),


				"item_cat_css_class"	=> $item["class"],
				"item_css_class"		=> "",

				"size"			=> $item["size"],
			),
			$item
		);


	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function validateItems(&$items) {
		global $_SESS , $base;

		//check to be on the right device
		if ($base->isTablet) {
			$dev = "tablet";
		} elseif ($base->isMobile) {
			$dev = "phone";
		} else {
			$dev = "desk";
		}

		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {

			$device = explode("," , $val["item_device"]);

			if (($dev == "tablet") && !in_array(2, $device)) {
				unset($items[$key]);
			} elseif (($dev == "phone") && !in_array(3, $device)) {
				unset($items[$key]);
			} elseif (($dev == "desk" ) && !in_array("1" , $device)) {
				unset($items[$key]);
			} elseif (is_array($_SESS["minibase"]["raw"]) && !in_array($val["item_status"] , array(1,2))) {
				unset($items[$key]);
			} elseif ($val["item_status"] != "1") {
				unset($items[$key]);
			} else {

				switch ($val["item_protected"]) {
					//logged in users
					case "1":
						if (!$_SESS["client"]) {
							unset($items[$key]);					
						} elseif ($val["item_groups"] && !count(array_intersect($_SESS["client"]["groups"] , explode("," , $val["item_groups"])))) {
							unset($items[$key]);						
						}					
					break;
					
					//guests only
					case "2":
						if ($_SESS["client"]) {
							unset($items[$key]);
						}					
					break;
				}
			}
			
		}
		
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	private function cacheMenus($menus) {
		global $_LANG_ID;

		if (is_array($menus)) {
			foreach ($menus as $key => $val) {
				$mid[] = $val["menu_id"];
			}			
		}

		if (!is_Array($mid)) {
			return "";
		}

				
		$items = $this->db->QFetchRowArray("
			SELECT * FROM 
				{$this->tables['core:menu_items']} as m
			LEFT JOIN
				{$this->tables['core:menu_items_lang']} as l
			ON 
				m.item_id = l.item_id AND 
				l.lang_id = {$_LANG_ID}			
			WHERE
				m.menu_id in (" . implode("," , $mid) . ")
			ORDER BY 
				item_parent ASC,
				item_order ASC
		");

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				if ($val["item_parent"]) {
					$this->cache[$val["menu_id"]][$val["item_parent"]]["sub"][] = $val;
				} else {
					if ($val["item_type"] == "4") {
						$this->dropmenus[$val["item_id"]] = $val["menu_id"];
					}
					
					$this->cache[$val["menu_id"]][$val["item_id"]] = $val;
				}				
			}			
		}

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getDropdownLinks($cat_id) {
		$this->__init();

		$menu = $this->dropmenus[$cat_id];
		$cat = $this->cache[$menu][$cat_id];

		if ($cat["item_type"] != 4) {
			return "";
		}


		switch ($cat["item_cat_type"]) {
			//category
			case "1":

				$items = $this->plugins["modules"]->GetModulesByParent($cat["item_cat_categories"]);

				if (is_array($items)) {
					foreach ($items as $key => $val) {
						$items[$key] = array(
							"id"		=> $val["mod_id"],
							"title"		=> $val["mod_name"],
							"link"		=> $val["link"],
							"target"	=> "",
							"rel"		=> "",
							"selected"	=> ($_GET["mod"] == $val["mod_module_code"]) && ($_GET["module_id"] == $val["mod_id"]) ? true : false,
							"icon"		=> "",
							"_item_title"	=> $this->_t("common")->blockReplace("ItemTitle", $val),

						);
					}
					
				}
				
				return $items;
			break;

			//manual
			case "0":
				$items = $this->cache[$cat["menu_id"]][$cat["item_id"]]["sub"];
				$this->validateItems($items);

				if (!is_array($items)) {
					return "";
				}

				foreach ($items as $key => $val) {

					switch ($val["item_type"]) {
						//link to page
						case "1":
							$mod = $this->plugins["modules"]->modules[$val["item_module"]];

							$_items[] = array(
								"id"		=> $mod["mod_id"],
								"title"		=> $mod["mod_name"],
								"link"		=> $mod["link"],
								"target"	=> "",
								"rel"		=> "",
								"selected"	=> ($_GET["mod"] == $mod["mod_module_code"]) && ($_GET["module_id"] == $mod["mod_id"]) ? true : false,
								"icon"		=> $val["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $val) : "",
								"_item_title"	=> $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $mod["mod_name"])),


							);
						break;

						//external link
						case "3":
							$_items[] = array(
								"id"		=> $val["item_id"],
								"title"		=> $val["item_name"],
								"link"		=> $val["item_link"],
								"target"	=> $val["item_link_target"] ? "_blank" : "",
								"rel"		=> $val["item_link_rel"],
								"selected"	=> "",
								"icon"		=> $val["item_icon"] ? $this->_t("common")->blockReplace("ItemIcon", $val) : "",
								"_item_title"	=> $this->_t("common")->blockReplace("ItemTitle", array("title"	=> $item["item_name"])),

							);
						break;
					}
					
				}

				return $_items;
			break;
		}
				
	}
	

}


?>